Imports System.Web.Security

Partial Class Protected_page
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Page.IsPostBack = False Then

            ' We check to see if there exists an FormAuthenticationTicket for the user
            ' and redirect the user to "Sign-in-form" if this ticket doesnt exist.

            If Not Request.IsAuthenticated = True Then
                Response.Redirect("Sign-in-form.aspx")
            Else
                ' This variables are declared so that we can get information from 
                ' the FormsAuthenticationTicket.

                Dim id As FormsIdentity = CType(User.Identity, FormsIdentity)
                Dim ticket As FormsAuthenticationTicket = id.Ticket

                ' This is information from the FormsAuthenticationTicket

                lblUsername.Text = ticket.Name
                lblCookiePath.Text = ticket.CookiePath
                lblExpireDate.Text = ticket.Expiration.ToString()
                lblExpired.Text = ticket.Expired.ToString()
                lblIsPersistent.Text = ticket.IsPersistent.ToString()
                lblIssueDate.Text = ticket.IssueDate.ToString()
                lblVersion.Text = ticket.Version.ToString()
                lblAdmin.Text = ticket.UserData

                If ticket.UserData = True Then
                    hplAdminPage.Visible = True
                End If
            End If
        End If
    End Sub

    Protected Sub btnSignOut_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSignOut.Click

        ' This code is executed when the user clicks the "Sign out" button and deletes the cookie and the ticket
        ' for the user.

        FormsAuthentication.SignOut()
        'Session.Abandon()
        FormsAuthentication.RedirectToLoginPage()
    End Sub
End Class
